import express from 'express';
import { isAdmin, requiredSignIn } from '../middleware/authMiddleware.js';
import upload from '../helpers/multer.js';
import {
  createStaff,
  deleteStaff,
  deleteStaffQualification,
  getSingleStaff,
  getStaff,
  pushStaffQualification,
  updateStaff,
  updateStaffQualification,
} from '../controllers/committeeController.js';
const committeeRouter = express.Router();

//create committee
committeeRouter.post(
  '/staff_create',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  createStaff
);
//get all committee
committeeRouter.get('/get_all_staff', getStaff);
committeeRouter.get('/get_single_staff/:id', getSingleStaff);

//delete committee
committeeRouter.delete(
  '/staff_delete/:id',
  requiredSignIn,
  isAdmin,
  deleteStaff
);

committeeRouter.put(
  '/staff_update/:id',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  updateStaff
);

// ===============committee qualification add ====================
// add qualification
committeeRouter.post(
  '/add_staff_qualification/:id',
  requiredSignIn,
  isAdmin,
  pushStaffQualification
);
// update
committeeRouter.post(
  '/update_q_staff',
  requiredSignIn,
  isAdmin,
  updateStaffQualification
);

// delete qualification  delete
committeeRouter.post(
  '/qualification_staff_delete',
  requiredSignIn,
  isAdmin,
  deleteStaffQualification
);

export default committeeRouter;
