import { Schema, model } from 'mongoose';

const studentSchema = new Schema(
  {
    student_name: {
      type: String,
      require: true,
      trim: true,
    },
    student_name_bd: {
      type: String,
      trim: true,
    },
    class_roll: {
      type: String,
      required: true,
    },
    class_name: {
      type: String,
      required: true,
    },
    gender: {
      type: String,
      required: true,
    },

    uniq_id: {
      type: String,
    },
    sub_scholar_id: {
      type: String,
    },
    scholar_id: {
      type: String,
    },
    father_name: {
      type: String,
      trim: true,
    },
    mother_name: {
      type: String,
      trim: true,
    },
    father_name_nid: {
      type: String,
    },
    mother_name_nid: {
      type: String,
    },
    phone_number: {
      type: String,
    },
    address: {
      type: String,
    },
    birth_reg_no: {
      type: String,
    },
    date_of_birth: {
      type: String,
    },
    blood_group: {
      type: String,
    },
    image: {
      type: Array,
    },
    birth_image: {
      type: Array,
    },
  },
  { timestamps: true }
);

const Student = model('student', studentSchema);

export default Student;
