import express from 'express';
import { isAdmin, requiredSignIn } from '../middleware/authMiddleware.js';
import upload from '../helpers/multer.js';
import {
  createStudent,
  deleteStudent,
  getStudent,
  updateStudent,
} from '../controllers/studentController.js';
const studentRouter = express.Router();

//create student
studentRouter.post(
  '/student_create',
  upload.fields([
    { name: 'image', maxCount: 1 },
    { name: 'birth_image', maxCount: 1 },
  ]),
  requiredSignIn,
  isAdmin,
  createStudent
);
//get all student
studentRouter.get('/get_all_student', getStudent);

//delete student
studentRouter.delete(
  '/student_delete/:id',
  requiredSignIn,
  isAdmin,
  deleteStudent
);
studentRouter.put(
  '/student_update/:id',
  upload.fields([
    { name: 'image', maxCount: 1 },
    { name: 'birth_image', maxCount: 1 },
  ]),
  requiredSignIn,
  isAdmin,
  updateStudent
);

export default studentRouter;
