import express from 'express';
import { isAdmin, requiredSignIn } from '../middleware/authMiddleware.js';
import upload from '../helpers/multer.js';
import {
  approvedBlog,
  createBlog,
  createClassRoutine,
  createNotice,
  createPresent,
  createRecord,
  createResult,
  createSpeech,
  deleteBlog,
  deleteClassRoutine,
  deleteImg,
  deleteNotice,
  deletePresent,
  deleteRecord,
  deleteResult,
  deleteSpeech,
  getBlog,
  getClassRoutine,
  getDatePresent,
  getImage,
  getLands,
  getNotice,
  getPresent,
  getRecord,
  getResult,
  getSpeech,
  updateLand,
  updateSpeech,
  uploadImage,
} from '../controllers/allController.js';
const allRouter = express.Router();

// ========================== notice ===============
//create Notice
allRouter.post(
  '/notice_create',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  createNotice
);
//get all Notice
allRouter.get('/get_all_notice', getNotice);
//delete product
allRouter.delete('/notice_delete/:id', requiredSignIn, isAdmin, deleteNotice);

// ========================== bolg ===============
//create Notice
allRouter.post(
  '/blog_create',
  upload.single('image'),
  requiredSignIn,
  createBlog
);
//get all
allRouter.get('/get_blog', getBlog);
//delete
allRouter.delete('/blog_delete/:id', requiredSignIn, deleteBlog);

// update
allRouter.post('/blog_approved', requiredSignIn, isAdmin, approvedBlog);

// =============Upload Img ===========

allRouter.post('/upload_img', upload.single('image'), uploadImage);
allRouter.get('/get_img', getImage);
allRouter.delete('/img_delete/:id', requiredSignIn, isAdmin, deleteImg);

// =============result ===========

allRouter.post(
  '/result_create',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  createResult
);
allRouter.get('/get_result', getResult);
allRouter.delete('/result_delete/:id', requiredSignIn, isAdmin, deleteResult);

// =============Class Routine ===========

allRouter.post(
  '/class_routine_create',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  createClassRoutine
);

allRouter.get('/get_class_routine', getClassRoutine);

allRouter.delete(
  '/class_routine_delete/:id',
  requiredSignIn,
  isAdmin,
  deleteClassRoutine
);

// =============Speech Routine ===========
allRouter.post(
  '/speech_create',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  createSpeech
);
allRouter.put(
  '/speech_update/:id',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  updateSpeech
);

// Speech
allRouter.get('/get_speech', getSpeech);
allRouter.delete('/speech_delete/:id', deleteSpeech);

// =====================Present=====================
allRouter.post('/add_present', requiredSignIn, createPresent);
allRouter.get('/get_present', getPresent);
allRouter.post('/get_date_present', getDatePresent);
allRouter.delete('/present_delete/:id', deletePresent);

// =====================record=====================
allRouter.post('/add_record', requiredSignIn, createRecord);
allRouter.get('/get_record', getRecord);
allRouter.delete('/record_delete/:id', deleteRecord);

// lands And Properties
allRouter.get('/get_lands', getLands);
allRouter.put('/land_update/:id', requiredSignIn, isAdmin, updateLand);

export default allRouter;
