import cloudinary from '../helpers/cloudinary.js';
import fs from 'fs';
import path from 'path';
import Notice from '../models/noticeModel.js';
import Teacher from '../models/teacherModel.js';
import Staff from '../models/staffModel.js';
import Imgs from '../models/imgModel.js';
import Result from '../models/resultModel.js';
import ClassRoutine from '../models/classRoutineModel.js';
import Present from '../models/presentModel.js';
import Speech from '../models/speechModel.js';
import Record from '../models/recordModel.js';
import Blog from '../models/blogModel.js';
import User from '../models/userModel.js';
import Land from '../models/landModel.js';

// ===================Notice======================

// create notice
export const createNotice = async (req, res, next) => {
  try {
    const { title, description } = req.body;

    // validation
    if (!title) {
      return res.send({ message: 'title is required' });
    }
    if (!description) {
      return res.send({ message: 'description is required' });
    }
    let urls;

    if (req.file !== undefined) {
      urls = req.file.filename;
    }

    const notice = await Notice.create({
      title: title,
      description: description,
      pdf_file: urls,
    });

    res.status(201).send({
      success: true,
      message: 'Notice created successfully',
      notice,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};

//get all Notice
export const getNotice = async (req, res) => {
  try {
    const notices = await Notice.find({});

    res.status(200).send({
      success: true,
      countTotal: notices.length,
      message: 'All notices get successfully ',
      notices,
    });
  } catch (error) {
    console.log(error);
  }
};

//delete Notice
export const deleteNotice = async (req, res) => {
  try {
    const id = req.params.id;
    const notice = await Notice.findById({ _id: id });

    if (notice.pdf_file) {
      const filePath = path.join('uploads', notice.pdf_file);

      fs.unlink(filePath, async (err) => {
        if (err) {
          console.error('Error deleting file:', err);
          return res.status(500).send({
            success: false,
            message: 'Error deleting file',
            error: err,
          });
        }
      });
    }

    await Notice.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Notice deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting notice',
      error,
    });
  }
};

// ===================blog======================

// create notice
export const createBlog = async (req, res, next) => {
  try {
    const { disc, user_id } = req.body;

    const user = await User.findById(user_id);

    if (!user_id) {
      return res.send({ message: 'Login first and try again' });
    }

    // Images File Handling
    const urls = [];
    const file = req.file;

    if (file) {
      const { path } = file;
      const result = await cloudinary.uploader.upload(path);
      const data = {
        url: result.secure_url,
        public_id: result.public_id,
      };
      urls.push(data);
      fs.unlinkSync(path);
    }

    const blog = await Blog.create({
      approved: false,
      user,
      disc,
      image: urls,
    });

    res.status(201).send({
      success: true,
      message: 'Blog created successfully',
      blog,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
      error,
    });
    next(error);
    console.error(error);
    console.log(error);
  }
};

//get all blog
export const getBlog = async (req, res) => {
  try {
    const blogs = await Blog.find({}).sort({ createdAt: -1 });

    res.status(200).send({
      success: true,
      message: 'All Blog get successfully ',
      blogs,
    });
  } catch (error) {
    console.log(error);
  }
};

//delete blog
export const deleteBlog = async (req, res) => {
  try {
    const id = req.params.id;
    const blog = await Blog.findById({ _id: id });

    if (blog.image) {
      for (const image of blog.image) {
        const { public_id } = image;
        await cloudinary.uploader.destroy(public_id);
      }
    }

    await Blog.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Blog deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting notice',
      error,
    });
  }
};
//update product
export const approvedBlog = async (req, res) => {
  try {
    const { id } = req.body; // Assuming you have the blog ID

    // Find the blog entry by ID
    const blog = await Blog.findById(id);

    if (!blog) {
      return res.status(404).send({ message: 'Blog not found' });
    }

    // Update the 'approved' field
    await Blog.updateOne({ _id: id }, { $set: { approved: true } });

    res.status(200).send({
      success: true,
      message: 'Blog approval updated successfully',
    });
  } catch (error) {
    res.status(500).send({
      success: false,
      message: 'Something went wrong. Please try again later.',
      error,
    });
    next(error);
    console.error(error);
  }
};

// =================== Images upload =======================

// img upload
export const uploadImage = async (req, res) => {
  try {
    // Images File Handling
    const urls = [];
    const file = req.file;

    if (file) {
      const { path } = file;
      const result = await cloudinary.uploader.upload(path);
      const data = {
        url: result.secure_url,
        public_id: result.public_id,
      };
      urls.push(data);
      fs.unlinkSync(path);
    } else {
      return res.status(500).send({ message: 'Image is required' });
    }

    const img = await Imgs.create({ image: urls });

    res.status(201).send({ success: true, message: 'Image Upload', data: img });
  } catch (error) {
    console.log(error);
    res.status(500).send({ success: false });
  }
};

// img upload and get
export const getImage = async (req, res) => {
  try {
    const imgs = await Imgs.find({}).sort({ createdAt: -1 });

    res.status(200).send({
      success: true,
      message: 'Img get successfully ',
      imgs,
    });
  } catch (error) {
    console.log(error);
  }
};
//delete Image
export const deleteImg = async (req, res) => {
  try {
    const id = req.params.id;
    const img = await Imgs.findById({ _id: id });
    if (img.image) {
      for (const image of img.image) {
        const { public_id } = image;
        await cloudinary.uploader.destroy(public_id);
      }
    }

    await Imgs.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Image deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Student',
      error,
    });
  }
};

// ===================Result======================

// create result
export const createResult = async (req, res, next) => {
  try {
    const {
      student_name,
      gpa,
      position,
      total_result,
      class_name,
      class_roll,
      exam_year,
      exam_name,
    } = req.body;

    // Validation
    if (
      !student_name ||
      !gpa ||
      !position ||
      !total_result ||
      !class_roll ||
      !class_name ||
      !exam_name ||
      !exam_year
    ) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    // Images File Handling
    let urls;
    if (req.file !== undefined) {
      urls = req.file.filename;
    }

    const result = await Result.create({
      student_name,
      gpa,
      position,
      total_result,
      class_name,
      class_roll,
      exam_name,
      exam_year,
      image: urls,
    });

    res.status(201).send({
      success: true,
      message: 'result created successfully',
      result,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};

//get all result
export const getResult = async (req, res) => {
  try {
    const results = await Result.find({}).sort('class_name');

    res.status(200).send({
      success: true,
      message: 'result get successfully ',
      results,
    });
  } catch (error) {
    console.log(error);
  }
};

//delete result
export const deleteResult = async (req, res) => {
  try {
    const id = req.params.id;
    const result = await Result.findById({ _id: id });

    // Ensure the callback function is provided
    if (result.image) {
      const filePath = path.join('uploads', result.image);
      fs.unlink(filePath, async (err) => {
        if (err) {
          console.error('Error deleting file:', err);
          return res.status(500).send({
            success: false,
            message: 'Error deleting file',
            error: err,
          });
        }
      });
    }

    await Result.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'result deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Student',
      error,
    });
  }
};

// ===================Class Routine======================

// create Class routine
export const createClassRoutine = async (req, res, next) => {
  try {
    const {
      subject_name,
      class_name,
      time_from,
      time_to,
      teacher_name,
      day_name,
    } = req.body;
    console.log(subject_name);
    // Validation
    if (
      !subject_name ||
      !teacher_name ||
      !class_name ||
      !time_from ||
      !time_to ||
      !day_name
    ) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    const classRoutine = await ClassRoutine.create({
      subject_name,
      class_name,
      teacher_name,
      time_from,
      time_to,
      day_name,
    });

    res.status(201).send({
      success: true,
      message: 'class Routine created successfully',
      classRoutine,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};

//get all class routine
export const getClassRoutine = async (req, res) => {
  try {
    const classRoutines = await ClassRoutine.find({});

    res.status(200).send({
      success: true,
      message: 'Class Routine get successfully ',
      classRoutines,
    });
  } catch (error) {
    console.log(error);
  }
};

//delete class routine
export const deleteClassRoutine = async (req, res) => {
  try {
    const id = req.params.id;
    await ClassRoutine.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Class Routine deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Student',
      error,
    });
  }
};

// ===================Speech======================

// create history
export const createSpeech = async (req, res, next) => {
  try {
    const { name, disc, title } = req.body;
    // Validation
    if (!name || !disc || !title) {
      return res.status(500).send({ message: 'All fields are required' });
    }
    // Images File Handling
    const urls = [];
    const file = req.file;

    if (file) {
      const { path } = file;
      const result = await cloudinary.uploader.upload(path);
      const data = {
        url: result.secure_url,
        public_id: result.public_id,
      };
      urls.push(data);
      fs.unlinkSync(path);
    }

    const speeches = await Speech.create({
      name,
      title,
      disc,
      image: urls,
    });

    res.status(201).send({
      success: true,
      message: 'Speech created successfully',
      speeches,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};
// update speech
export const updateSpeech = async (req, res, next) => {
  try {
    const { name, disc, title } = req.body;
    const id = req.params.id;

    // Validation
    if (!name || !disc || !title) {
      return res.status(500).send({ message: 'All fields are required' });
    }
    // Images File Handling
    const oldSpeech = await Speech.findById({ _id: id });

    const file = req.file;

    const urls = file !== undefined ? [] : oldSpeech.image;

    if (file) {
      // delete old images
      for (const image of oldSpeech.image) {
        const { public_id } = image;
        await cloudinary.uploader.destroy(public_id);
      }

      const { path } = file;
      const result = await cloudinary.uploader.upload(path);
      const data = {
        url: result.secure_url,
        public_id: result.public_id,
      };
      urls.push(data);
      fs.unlinkSync(path);
    }

    const speeches = await Speech.findByIdAndUpdate(
      id,
      {
        name,
        title,
        disc,
        image: urls,
      },
      { new: true }
    );
    await speeches.save();

    res.status(201).send({
      success: true,
      message: 'Speech updated successfully',
      speeches,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};
//get all Speeches
export const getSpeech = async (req, res) => {
  try {
    const speeches = await Speech.find({}).sort({ createdAt: -1 });

    res.status(200).send({
      success: true,
      message: 'Speeches get successfully ',
      speeches,
    });
  } catch (error) {
    console.log(error);
  }
};
export const deleteSpeech = async (req, res) => {
  try {
    const id = req.params.id;
    await Speech.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Speech deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Present',
      error,
    });
  }
};

// ======================Present===========================

export const createPresent = async (req, res, next) => {
  try {
    const {
      date,
      class_name,
      total_male_present,
      total_female_present,
      total_present,
    } = req.body;
    console.log(req.body);

    // Validation
    if (
      !class_name ||
      !date ||
      !total_male_present ||
      !total_female_present ||
      !total_present
    ) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    const students = await Student.find({ class_name });

    const total_student = students?.length;

    const present = await Present.create({
      date,
      class_name,
      total_student,
      total_present,
      total_male_present,
      total_female_present,
      total_absence: total_student - Number(total_present),
    });

    res.status(201).send({
      success: true,
      message: 'present add successfully',
      present,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};

//get all present
export const getPresent = async (req, res) => {
  try {
    const presents = await Present.find({}).sort({ createdAt: -1 });

    res.status(200).send({
      success: true,
      message: 'Present Shit get successfully ',
      presents,
    });
  } catch (error) {
    console.log(error);
  }
};
//get all Student
export const getDatePresent = async (req, res) => {
  try {
    const { searchDate } = req.body;
    const presentDate = await Present.find({ date: searchDate }).sort(
      'class_name'
    );

    res.status(200).send({
      success: true,
      message: 'Attendance Shit get successfully ',
      presentDate,
    });
  } catch (error) {
    console.log(error);
  }
};
//delete present
export const deletePresent = async (req, res) => {
  try {
    const id = req.params.id;
    await Present.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Present deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Present',
      error,
    });
  }
};

// =============academic Record ================

// create Record
export const createRecord = async (req, res, next) => {
  try {
    const { exam, year, examinee, pass, a_plus, a, a_minus } = req.body;

    // Validation
    if (!exam || !year || !examinee || !pass || !a_plus || !a || !a_minus) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    const record = await Record.create({
      exam,
      year,
      examinee,
      pass,
      a_plus,
      a,
      a_minus,
    });

    res.status(201).send({
      success: true,
      message: 'Record created successfully',
      record,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};

//get all Record
export const getRecord = async (req, res) => {
  try {
    const records = await Record.find({}).sort('year');

    res.status(200).send({
      success: true,
      message: 'records get successfully ',
      records,
    });
  } catch (error) {
    console.log(error);
  }
};

//delete Record
export const deleteRecord = async (req, res) => {
  try {
    const id = req.params.id;
    await Record.findByIdAndDelete(id);
    res.status(200).send({
      success: true,
      message: 'Record deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Student',
      error,
    });
  }
};
// ===============lands
//get all lands
export const getLands = async (req, res) => {
  try {
    const lands = await Land.find({});

    res.status(200).send({
      success: true,
      message: 'lands get successfully ',
      lands,
    });
  } catch (error) {
    console.log(error);
  }
};
export const updateLand = async (req, res, next) => {
  try {
    const { disc } = req.body;
    const id = req.params.id;

    // Validation
    if (!disc) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    const land = await Land.findByIdAndUpdate(
      id,
      {
        disc,
      },
      { new: true }
    );
    await land.save();

    res.status(201).send({
      success: true,
      message: 'land updated successfully',
      land,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};
